import asyncio
from py_pli.pylib import VUnits
import config_enum.scan_table_enum as scan_table_enum
import time as t
from datetime import datetime as DT

# 2020-09-29/Kay Struebing
# Detektor-Tests
# Ref-PD
# ABS-PD
# PMT1

fmspos=-1
elspos=-1
bldpos=-1

# Init Functions

async def init():
    await VUnits.instance.hal.StartupHardware()
    print("Hardware started,")
    await VUnits.instance.hal.InitializeDevice()
    print("Device initialized.\n")

async def init_eef():
    await VUnits.instance.hal.nodes["EEFNode"].StartFirmware()
    print(f"eef initialized.\n")

async def init_all():
    await init()
    await init_eef()

# Mover Functions

async def all_home():
#    step_error = await VUnits.instance.hal.oneMoverDevices["ApertureSlider1"].Home()    
#    print(f"ApertureSlider1 homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.focusMover.Home()
    print(f"FocusMover homed, Error = {step_error}\n")
    step_error = await VUnits.instance.hal.filterModuleSlider.Home()
    print(f"FilterModuleSlider homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.scan_table.Home()
    print(f"ScanTable homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.plateDoor.Home()
    print(f"PlateDoor homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"].Home()        
    print(f"ExcitationLightSelector homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.oneMoverDevices["BottomLightDirector"].Home()
    print(f"BottomLightDirector homed,Error = {step_error}\n")
    print('All Mover at home.')

async def fm_home():
    fm = VUnits.instance.hal.focusMover
    await fm.Home()
    fm_err = fm.Mover.LastHomeStepErrors
    print(f"FocusMover Step Errors: {fm_err}")

async def fm_up():
    focus_mover = VUnits.instance.hal.focusMover
    position = 3.95
    await focus_mover.UseProfile(1)
    await focus_mover.Move(position)
    print(f"Focus Mover Position {position}")

async def fm_down():
    focus_mover = VUnits.instance.hal.focusMover
    position = 12.5
    await focus_mover.UseProfile(1)
    await focus_mover.Move(position)
    print(f"Focus Mover Position {position}")

async def fms_home():
    global fmspos
    fms = VUnits.instance.hal.filterModuleSlider
    await fms.Home()
    fms_err = fms.Mover.LastHomeStepErrors
    print(f"FilterModuleSlider Step Errors: {fms_err}")
    fmspos=0

async def fms(filter_nr):
    global fmspos
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.UseProfile(1)
    position = 55.2 + (filter_nr - 1) * 24.0
    await filter_slider.Move(position)
    print(f"Filter Module {filter_nr}")
    fmspos=filter_nr

async def fms_move(position):
    global fmspos
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.UseProfile(1)
    await filter_slider.Move(position)
    print(f"Filter Module {position}")
    fmspos=-1

async def pd_open():
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.UseProfile(1)    
    await plate_door.Open()    
    print("Plate Door open.")

async def pd_close():
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.UseProfile(1)    
    await plate_door.Close()    
    print("Plate Door closed.")   

async def as1_init():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.InitializeDevice()
    stepErrors = await as1.Home()    
    print("Aperture Slider homed, Step-Error: " + str(stepErrors))

async def as1_home():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.Home()
    as_err = as1.Mover.LastHomeStepErrors
    print(f"ApertureSlider 1 Step Errors: {as_err}")

async def as1_1():
    # Aperture 1,6mm
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(4.4)
    print("Aperture: 1,6mm")

async def as1_close():
    # to adjust the close position
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)    
    await as1.Move(0.5)
    print("Aperture 1 closed.")

async def as1_3():
    # Aperture 3mm
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(-4.2)
    print("Aperture: 3mm")

async def as1(pos):
    # Move ApertureSlider to absolute position for calibration
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(pos)
    print(f"Aperture Position: {pos}")

async def els_init():
    global elspos
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.InitializeDevice()
    stepErrors = await els.Home()    
    print("ELS homed, Step-Error: " + str(stepErrors))
    elspos=0

async def els_1():
    # Move ELS to increase beam diameter
    global elspos
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.UseProfile(1)
    await els.Move(23.8)
    print("Exc.LightSel moved to Flash 1 (increase beam diameter).")
    elspos=1

async def els_2():
    # Move ELS to decrease beam diameter
    global elspos
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.UseProfile(1)
    await els.Move(203.8)
    print("Exc.LightSel moved to Flash 2 (decrease beam diameter).")
    elspos=2

async def els(pos):
    # For adjustment
    global elspos
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.UseProfile(1)
    await els.Move(pos)
    print(f"Exc.LightSel moved to {pos}")
    elspos=-1

async def bld_init():
    global bldpos
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.InitializeDevice()
    stepErrors = await bld.Home()    
    print("BottomLightDirector homed, Step-Error: " + str(stepErrors))
    bldpos=0

async def bld_home():
    global bldpos
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.Home()  
    bld_err = bld.Mover.LastHomeStepErrors
    print(f"Bottom Light Director Step Errors: {bld_err}")
    bldpos=0

async def bld_pd():
    global bldpos
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.UseProfile(1)
    await bld.GotoPosition(["Positions", "ABS_Photo Diode_1_Position", None])
    print("Bottom Light Director moved to ABS PD")
    bldpos=1

async def bld_bottom():
    global bldpos
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.UseProfile(1)
    await bld.GotoPosition(["Positions", "PMT_Bottom_Reading_Position", None])
    print("Bottom Light Director moved to Bottom Reading Position")
    bldpos=2

async def bld_top():
    global bldpos
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.UseProfile(1)
    await bld.GotoPosition(["Positions", "PMT_Top_Reading_Position", None])
    print("Bottom Light Director moved to Top Reading Position")
    bldpos=3

async def st_home():
    st = VUnits.instance.hal.scan_table
    await st.Home()
    print(f"Scan Table X Step Errors: {st.CoreXY.LastHomeStepErrors[0]}")
    print(f"Scan Table Y Step Errors: {st.CoreXY.LastHomeStepErrors[1]}")
     

# Sequencer Functions

signals = {
    'flash'     : (1 << 23),
    'alpha'     : (1 << 22),
    'ingate2'   : (1 << 17),
    'ingate1'   : (1 << 16),
    'hvgate2'   : (1 << 13),
    'hvgate1'   : (1 << 12),
    'hvon3'     : (1 << 10),
    'hvon2'     : (1 <<  9),
    'hvon1'     : (1 <<  8),
    'rstaux'    : (1 <<  6),
    'rstabs'    : (1 <<  5),
    'rstref'    : (1 <<  4),
    'rstpmt2'   : (1 <<  1),
    'rstpmt1'   : (1 <<  0),
}


triggers = {
    'trf'   : (1 << 8),
    'aux'   : (1 << 6),
    'abs'   : (1 << 5),
    'ref'   : (1 << 4),
    'pmt3'  : (1 << 2),
    'pmt2'  : (1 << 1),
    'pmt1'  : (1 << 0),
}

async def get_results(address, size):
    meas = VUnits.instance.hal.measurementUnit.MeasurementFunctions
    #meas = get_measurement_endpoint()
    return (await meas.ReadResults(address, size, timeout=5))[:size]


async def write_sequence(address, sequence):
    if len(sequence) > 28:
        raise Exception(f"Maximum sequence length of 28 instructions exceeded.")
    
    meas = VUnits.instance.hal.measurementUnit.MeasurementFunctions

    buffer = [0] * 28
    for i in range(len(sequence)):
        buffer[i] = sequence[i]

    await meas.WriteSequence(address, len(sequence), buffer, timeout=5)


async def start_sequence(address):
    measurement_unit = VUnits.instance.hal.measurementUnit
    meas = measurement_unit.MeasurementFunctions

    await meas.StartSequence(address, timeout=1)

    # status = (await meas.GetStatus(timeout=1))[0]
    # print(f"Sequence Status -> Ready = {status & 0x01} InstValid = {(status >> 3) & 0x01} ProgramCounter = {(status >> 4) & 0x0F}")
    # while (status & 0x01) == 0:
    #     status = (await meas.GetStatus(timeout=1))[0]
    #     print(f"Sequence Status -> Ready = {status & 0x01} InstValid = {(status >> 3) & 0x01} ProgramCounter = {(status >> 4) & 0x0F}")
    # print(f"Sequence finished")

# PMT Functions

async def hvpmt1on():
    address = 0
    sequence = [
            0x02000000 | signals['hvon1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)
    print('=============HV PMT1 On!!!==================')

async def hvpmt1off():
    address = 0
    sequence = [
            0x03000000 | signals['hvon1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)
    print('=============HV PMT1 Off!!!==================')

async def hvgate(enable):
    address = 0
    if enable:
        sequence = [
            0x02000000 | signals['hvgate1'],
            0x00000000,
        ]
    else:
        sequence = [
            0x03000000 | signals['hvgate1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)

async def darkcount(iterations, cnt_window=1000, pre_cnt_window=100000):
    address = 0
    sequence = [
        0x7C000000 | (pre_cnt_window - 1),  # TimerWaitAndRestart(pre_cnt_window - 1)
        0x88B80000,                         # PulseCounterControl(ch=0, add=0, RstCnt=1, RstPreCnt=1, corr=1)
        0x07000000 | (cnt_window - 1),      # Loop(cnt_window - 1)
        0x7C000000 | (pre_cnt_window - 1),  #     TimerWaitAndRestart(pre_cnt_window - 1)
        0x88D00000,                         #     PulseCounterControl(ch=0, add=1, RstCnt=0, RstPreCnt=1, corr=0)
        0x05000000,                         # LoopEnd()
        0x80900000,                         # GetPulseCounterResult(ch=0, rel=0, RstCnt=1, add=0, dword=0, addrReg=0, addr=0)
        0x00000000,                         # Stop(0)
    ]
    await init()
#    await hvpmt1on()
    await hvgate(enable=True)
    await write_sequence(address, sequence)
    with open('pmt_test_2020-09-29.txt', mode='a') as file:
        window_ms = 0.00001 * cnt_window * pre_cnt_window
        time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M')
        file.write(f"Darkcount PMT 1, {time_stamp} \n")
        file.write(f"index;count (window = {window_ms} ms)\n")
        for i in range(iterations):
            try:
#                await start_sequence(address, poll_interval=1)
                await start_sequence(address)
                results = await get_results(address=0, size=1)
                print(f"{i+1}, {results[0]}")
                file.write(f"{i+1}, {results[0]}\n")
            except BaseException as ex:
                print(f"darkcount() failed: {ex}")
                file.write(f"darkcount() failed: {ex}\n")
    await hvgate(enable=False)
#    await hvpmt1off()

# Flashlamp Functions

async def trigger_n_times(frequency, iterations, duration_us, high_pwr=0):
    '''
    Martin Pfeifer, 24.08.2020:
    
    frequency [Hz]: 0..1000
    duration [µs]: frequency 500: duration: 1000
              frequency 1000: duration: 500
    flash_power: Minimum 3.3V: 2147483647
                 Maximum 2.5V: 1626881551
                 Tested 3.14V: 2043363228
    high_power: default: 0 :low power
                         1 :high power      
    '''
    node = VUnits.instance.hal.nodes["EEFNode"]
    mf = VUnits.instance.hal.measurementUnit.MeasurementFunctions

    # Cancel if HighPower is set and Freqency above 500
    if frequency > 500 and high_pwr == 1:
        raise Exception(f"No HighPwr above 500Hz")
    
    print(f"Trigger Flashlamp {frequency}Hz, {iterations} times, {duration_us}µs duty.\n")
    # Set the Flash_Pwr
   
    #await node.SetAnalogOutput(2, 1843363228)
    #await asyncio.sleep(0.1)
    curr_value = 1843363228
    await mf.SetParameter(0, curr_value)
    
    # Set HighPower 
    #if high_pwr == 1:
    #    await node.SetDigitalOutput(4,0) #caution -> inverted
    #    await asyncio.sleep(0.1)
    #else:
    #    await node.SetDigitalOutput(4,1) #caution -> inverted 
    #    await asyncio.sleep(0.1)

    await mf.SetParameter(1, high_pwr)

    ontime = int(100 * duration_us)
    offtime = int(1 / frequency * 1e8 - ontime)
    loop_a = int(iterations / 65536)
    loop_b = int(iterations % 65536)
    data = []
    if loop_a > 0:
        data.extend([
            0x07000000 | (loop_a - 1),      # Loop A Multiple of 2^16
            0x07000000 | (65536 - 1),       # Loop Inner
            0x7C000000 | (ontime - 1),      # Wait for offtime timer then start ontime timer
            0x02000000 | signals['flash'],  # Set Flash_Trg high
            0x7C000000 | (offtime - 1),     # Wait for ontime timer then start offtime timer
            0x03000000 | signals['flash'],  # Set Flash_Trg low
            0x05000000,                     # LoopEnd
            0x05000000,                     # LoopEnd
        ])
    if loop_b > 0:
        data.extend([
            0x07000000 | (loop_b - 1),      # Loop B Remainder
            0x7C000000 | (ontime - 1),      # Wait for offtime timer then start ontime timer
            0x02000000 | signals['flash'],  # Set Flash_Trg high
            0x7C000000 | (offtime - 1),     # Wait for ontime timer then start offtime timer
            0x03000000 | signals['flash'],  # Set Flash_Trg low
            0x05000000,                     # LoopEnd
        ])
    data.extend([
        0x00000000,                     # Stop
    ])
    await write_sequence(0, data)
    await start_sequence(0)
    
async def f_time(duration_s, power):
    print(f"Flash-Lamp Check, Duration {duration_s} sec")
    frequency = 100
    duty = 0.5
    iterations = duration_s * frequency
    duration = int(1 / frequency * 1000000 * duty)
    await trigger_n_times(frequency, iterations, duration, power)

# Reference Photodiode Functions


async def reftest(frequency, iterations, flashes=1, flash_mode=1, comment=''):
    '''
    ml 200929:
    
    frequency [Hz]: 0..1000
    '    : : Minimum 3.3V: 2147483647
                 Maximum 2.5V: 1626881551
                 Tested 3.14V: 2043363228
    flash_mode: default: 0 :high speed, low power
                         1 :high power, low speed     
    '''
    node = VUnits.instance.hal.nodes["EEFNode"]
    mf = VUnits.instance.hal.measurementUnit.MeasurementFunctions

    # Limit Freqency for High Power Mode
    if frequency > 500 and flash_mode == 1:
        frequency = 500

    # Set the Flash_Pwr
    curr_value = 1843363228
    await mf.SetParameter(0, curr_value)
    
    # Set ontime based on Power Mode 
    if flash_mode == 1:
        ontime = 120000
    else:
        ontime = 60000
    
    await mf.SetParameter(1, flash_mode)

    offtime = int(1 / frequency * 1e8 - ontime)
    print(f"Trigger Flashlamp {frequency}Hz, {iterations} Iterations, {flashes} Flashes, Mode {flash_mode}, OnTime {ontime} ticks, OffTime {offtime} ticks\n")
    
    address = 0
    abssequ = [
        0x84000000,                     # GetAnalogResult (ch=4, rel=0, IgnoreRange=0, IsHiRange=0, add=0, dword=0, addrReg=0, addr=0)
        0x84100001,                     # GetAnalogResult (ch=4, rel=0, IgnoreRange=0, IsHiRange=1, add=0, dword=0, addrReg=0, addr=1)
        0x85000002,                     # GetAnalogResult (ch=5, rel=0, IgnoreRange=0, IsHiRange=0, add=0, dword=0, addrReg=0, addr=2)
        0x85100003,                     # GetAnalogResult (ch=5, rel=0, IgnoreRange=0, IsHiRange=1, add=0, dword=0, addrReg=0, addr=3)
        0x8C000000,                     # ClearResultBuffer 0 
        0x8C000001,                     # ClearResultBuffer 1 
#        0x8C000002,                     # ClearResultBuffer 2 
#        0x8C000003,                     # ClearResultBuffer 3 
        0x07000000 | (flashes - 1),     # Loop flashes
        0x02000000 | signals['rstref'] | signals['rstabs'],  # SetSignal Reset RefInt, reset ABSInt
        0x7C000000 | (ontime - 1),      # wait for last timer then start ontime timer
        0x02000000 | signals['flash'], # | signals['rstref'] | signals['rstabs'],  # SetSignal Flash_Trg high
        0x7C000000 | (100),             # Start Timer for 1µs
        0x03000000 | signals['flash'] | signals['rstref'] | signals['rstabs'],  # ResetSignal Flash_Trg low
        0x7C000000 | (2000),            # Start Timer for 20µs
        0x7C000000 | (100),             # Start Timer for 1µs
        0x01000000 | triggers['ref'] | triggers['abs'],      # SetTriggerOutput
        0x7C000000 | (500),             # Start Timer for 5µs
        0x02000000 | signals['rstref'] | signals['rstabs'],  # SetSignal 
        0x7C000000 | (500),             # Start Timer for 5µs
        0x84080000,                     # GetAnalogResult (ch=4, rel=0, IgnoreRange=0, IsHiRange=0, add=1, dword=0, addrReg=0, addr=0)
        0x84180001,                     # GetAnalogResult (ch=4, rel=0, IgnoreRange=0, IsHiRange=1, add=1, dword=0, addrReg=0, addr=1)
        0x85080002,                     # GetAnalogResult (ch=5, rel=0, IgnoreRange=0, IsHiRange=0, add=1, dword=0, addrReg=0, addr=2)
        0x85180003,                     # GetAnalogResult (ch=5, rel=0, IgnoreRange=0, IsHiRange=1, add=1, dword=0, addrReg=0, addr=3)
        0x7C000000 | (offtime - 1),     # Wait for ontime timer then start offtime timer
        0x03000000 | signals['flash'],  # ResetSignal Flash_Trg low
        0x05000000,                     # LoopEnd flashes
        0x00000000,                     # Stop
    ]
    await write_sequence(address, abssequ)
    resultsum = [0] *4
    with open('absref_test20201028a.txt', mode='a') as file:
        time_stamp = DT.now().strftime('%y%m%d %H:%M:%S')
        file.write(f"\n{time_stamp}, Reference Test  {comment}\n")
        file.write(f"Trigger Flashlamp {frequency}Hz, {iterations} Iterations, {flashes} Flashes, Mode {flash_mode}, OnTime {ontime} Ticks, OffTime {offtime} Ticks\n")
        file.write(f"FMS Position {fmspos}, ELS Position {elspos}, BLD Position {bldpos}\n")
        file.write(f"index\tRefLo\tRefHi\tAbsLo\tAbsHi \n")
        for i in range(iterations):
            try:
                await start_sequence(address)
                results = await get_results(address=0, size=4)
                for index in range(0, len(results)):
                    resultsum[index] = resultsum[index] + results[index]
                print(f"{i+1}, {results}")
#                print(f"{i+1}, {results[0]}, {results[1]}, {results[2]}, {results[3]}")
                file.write(f"{i+1}\t{results[0]}\t{results[1]}\t{results[2]}\t{results[3]}\n")
            except BaseException as ex:
                print(f"reftest() failed: {ex}")
        time_stamp = DT.now().strftime('%y%m%d %H:%M:%S')
        file.write(f"\n{time_stamp}, Reference Test {comment} :\t{resultsum[0]/iterations}\t{resultsum[1]/iterations}\t{resultsum[2]/iterations}\t{resultsum[3]/iterations}\n")
    print('Done')

async def elsscan(start=0, stop=3600, step=150):
    '''
    ml 201001:
    
    '''
    await els_init()
    for i in range(start, stop, step):
        pos = i*0.1
        await els(pos)
        await reftest(100,10,1,1,pos)
    await els_init()
    print('Done')
        
async def fmsscan(start=350, stop=400, step=1):
    '''
    ml 201001:
    fmsscan
    '''
    await fms_home()
    for i in range(start, stop, step):
        pos = i*0.1
        await fms_move(pos)
        await reftest(100,10,1,1,pos)
    await fms_home()
    print('Done')
        
async def darkscan(iterations=10):
    '''
    ml 201001:
    darkscan
    '''
    await fms_home()
    await fms(6)
    for i in range(9):
        await reftest(100,iterations,i+1,1)
    for i in range(9):
        await reftest(100,iterations,(i+1)*10,1)
    for i in range(5):
        await reftest(100,iterations,(i+1)*100,1)
    await fms_home()
    print('Done')
        



# Logging functions

def log_entry(fname, entry):
    with open (fname, 'a') as file:        
        file.write(entry + "\n")
        print(f"Log-Entry written in {fname}")

def log_header(fname, header):
    time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M-%S')        
    with open(fname, 'w') as file:
        file.write(time_stamp + " " + header + "\n")

def log_footer(fname, footer):
    time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M-%S')    
    with open(fname, 'a') as file:
        file.write(time_stamp + " " + footer + "\n")
        print(f"Log-file write to {fname}")


